# 帳票設計書 3-Indices Report

## 概要

本ドキュメントは、OpenSearchの `_cat/indices` APIが出力するIndices Reportの帳票設計書である。インデックスの一覧と統計情報をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Indices Reportは、クラスタ内の全インデックスまたは指定インデックスのヘルス、ステータス、ドキュメント数、ストアサイズなどの統計情報を一覧表示する帳票である。4つの内部APIを並列で呼び出し、結果を統合してテーブルを構築する。

**業務上の目的・背景**：クラスタに存在するインデックスの状態を包括的に把握し、ストレージ使用量、ドキュメント数、シャード構成などの情報に基づいてインデックスの管理・運用判断を行うために必要である。

**帳票の利用シーン**：インデックスの状態確認、ストレージ容量の監視、不要インデックスの特定、インデックスのヘルス問題の調査、パフォーマンスチューニング時の基礎データ収集に利用される。

**主要な出力内容**：
1. インデックスのヘルスステータス（green/yellow/red）とオープン/クローズ状態
2. シャード構成（プライマリ数、レプリカ数）
3. ドキュメント数と削除済みドキュメント数
4. ストアサイズ（全体およびプライマリのみ）
5. 各種統計（検索、インデキシング、マージ、リフレッシュ、キャッシュ等）

**帳票の出力タイミング**：ユーザーが `GET /_cat/indices` または `GET /_cat/indices/{index}` エンドポイントにHTTPリクエストを送信した時点で出力される。

**帳票の利用者**：クラスタ管理者、SRE、データエンジニア、アプリケーション開発者。

## 帳票種別

一覧表（テキストテーブル形式のインデックス情報一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Cat インデックス | `GET /_cat/indices` | HTTP GETリクエスト |
| - | Cat インデックス（指定） | `GET /_cat/indices/{index}` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A（REST APIレスポンス） |
| 向き | N/A |
| ファイル名 | N/A（HTTPレスポンスボディとして返却） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

インデックス数分の行を持つテキストテーブルとしてインデックス情報を出力する。

```
┌───────────────────────────────────────────────────────────┐
│ health  status  index      uuid    pri  rep  docs.count  │
├───────────────────────────────────────────────────────────┤
│ green   open    my-index   abc..   5    1    1000        │
│ yellow  open    logs-001   def..   3    1    50000       │
└───────────────────────────────────────────────────────────┘
```

### 明細部（デフォルト表示カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | health | ヘルスステータス | ClusterIndexHealth.getStatus() | 小文字文字列 |
| 2 | status | オープン/クローズ | IndexMetadata.getState() | 小文字文字列 |
| 3 | index | インデックス名 | indexName | 文字列 |
| 4 | uuid | インデックスUUID | IndexMetadata.getIndexUUID() | 文字列 |
| 5 | pri | プライマリシャード数 | ClusterIndexHealth.getNumberOfShards() | 右寄せ数値 |
| 6 | rep | レプリカ数 | ClusterIndexHealth.getNumberOfReplicas() | 右寄せ数値 |
| 7 | docs.count | ドキュメント数 | primaryStats.getDocs().getCount() | 右寄せ数値 |
| 8 | docs.deleted | 削除済みドキュメント数 | primaryStats.getDocs().getDeleted() | 右寄せ数値 |
| 9 | store.size | ストアサイズ（全体） | totalStats.getStore().size() | 右寄せバイト値 |
| 10 | pri.store.size | ストアサイズ（プライマリ） | primaryStats.getStore().size() | 右寄せバイト値 |

### 明細部（主要オプションカラム - default:false）

- **作成日時**: creation.date, creation.date.string
- **検索統計**: search.query_total, search.query_time, search.fetch_total 等
- **インデキシング統計**: indexing.index_total, indexing.index_time 等
- **キャッシュ統計**: query_cache.memory_size, request_cache.memory_size 等
- **マージ統計**: merges.total, merges.total_time 等
- **セグメント統計**: segments.count, segments.memory 等
- **ウォーマー統計**: warmer.current, warmer.total 等
- **メモリ**: memory.total
- **検索スロットリング**: search.throttled

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| index | インデックス名パターン（カンマ区切り） | No |
| health | ヘルスステータスでフィルタ（green/yellow/red） | No |
| local | ローカルクラスタ状態を使用 | No |
| include_unloaded_segments | アンロード済みセグメントを含める | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | `s` パラメータで任意指定可能 | 任意 |

### 改ページ条件

改ページは発生しない（ただしPaginationStrategy による将来的なページネーション対応の基盤あり）。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| GetSettingsResponse | インデックス設定（権限解決・検索スロットリング確認） | GetSettingsRequest |
| ClusterStateResponse | インデックスメタデータ | ClusterStateRequest |
| ClusterHealthResponse | インデックスヘルス情報 | ClusterHealthRequest |
| IndicesStatsResponse | インデックス統計情報 | IndicesStatsRequest |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| health | ClusterIndexHealth が null で IndexStats が存在する場合 "red*" | なし | ヘルス不明のインデックス |
| creation.date.string | STRICT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(creationDate)) | なし | ISO8601形式 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/indices リクエスト受信] --> B[doCatRequest]
    B --> C[GetSettingsRequest 実行 - 権限解決]
    C --> D[ClusterStateRequest 実行]
    D --> E{Pagination / Response Limit チェック}
    E --> F[GroupedActionListener で並列実行]
    F --> G[IndicesStatsRequest 実行]
    F --> H[ClusterHealthRequest 実行]
    G --> I[4レスポンス統合]
    H --> I
    I --> J[buildTable でテーブル構築]
    J --> K[RestTable.buildResponse でレスポンス生成]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ResponseLimitBreachedException | インデックス数が制限超過 | "Too many indices requested." | 制限値の調整またはインデックス名パターンの指定 |
| DuplicateParameterError | master_timeout と cluster_manager_timeout の両方が指定 | DUPLICATE_PARAMETER_ERROR_MESSAGE | 片方のみ指定する |
| master_timeout 非推奨警告 | master_timeout パラメータ使用時 | DeprecationWarning | cluster_manager_timeout を使用 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | インデックス数分の行（数個～数千） |
| 目標出力時間 | 数百ミリ秒～数秒（4つの内部API呼び出し） |
| 同時出力数上限 | ResponseLimitSettings.getCatIndicesResponseLimit() で制限可能 |

## セキュリティ考慮事項

- `allowSystemIndexAccessByDefault()` が `true` に設定されている。
- GetSettingsRequest を使用して権限解決を行うため、セキュリティプラグイン導入時は認可されたインデックスのみが表示される。
- `master_timeout` パラメータはバージョン3.0で廃止予定。

## 備考

- RestIndicesAction は AbstractListAction を継承しており、ページネーション基盤に対応する設計。ただし現在 `isActionPaginated()` は `false` を返す。
- healthパラメータでヘルスステータスによるフィルタリングが可能。
- クローズされたインデックスの場合、統計情報は空の CommonStats として扱われる。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | 行411-889: getTableWithHeader() で全カラム定義を確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | 行142-256: doCatRequest() で4段階のAPI呼び出しチェーンを理解 |

**主要処理フロー**:
1. **行143-156**: パラメータ解析（index, local, cluster_manager_timeout, include_unloaded_segments）
2. **行166-253**: GetSettingsRequest → ClusterStateRequest → GroupedActionListener で IndicesStatsRequest + ClusterHealthRequest を並列実行
3. **行346-395**: createGroupedListener() で4レスポンスを統合

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | 行892-1230: buildTable() でインデックスごとに行を構築 |

### プログラム呼び出し階層図

```
AbstractListAction.prepareRequest()
    |
    +-- RestIndicesAction.doCatRequest() [行142]
           |
           +-- sendGetSettingsRequest() [行275]
           |      |
           |      +-- sendClusterStateRequest() [行293]
           |             |
           |             +-- validateRequestLimit() [行258]
           |             +-- GroupedActionListener (size=4) [行346]
           |                    |
           |                    +-- sendIndicesStatsRequest() [行329]
           |                    +-- sendClusterHealthRequest() [行311]
           |                    |
           |                    +-- buildTable() [行892]
           |
           +-- RestTable.buildResponse()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GET /_cat/indices       --->  GetSettingsRequest              --->  テキストテーブル
GET /_cat/indices/{idx}          |                                  (インデックス数分の行)
                                 v
                          GetSettingsResponse (権限解決)
                                 |
                          ClusterStateRequest
                                 |
                                 v
                          ClusterStateResponse (メタデータ)
                                 |
                          +------+------+
                          |             |
                   IndicesStatsReq  ClusterHealthReq
                          |             |
                          v             v
                   IndicesStatsRes  ClusterHealthRes
                          |             |
                          +------+------+
                                 |
                                 v
                          buildTable() で統合 → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | ソース | Indices Report メイン処理 |
| AbstractListAction.java | `server/src/main/java/org/opensearch/rest/action/list/AbstractListAction.java` | ソース | ページネーション対応基底クラス |
| RestIndicesActionTests.java | `server/src/test/java/org/opensearch/rest/action/cat/RestIndicesActionTests.java` | テスト | ユニットテスト |
| ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | ソース | レスポンス制限設定 |
| IndexPaginationStrategy.java | `server/src/main/java/org/opensearch/action/pagination/IndexPaginationStrategy.java` | ソース | ページネーション戦略 |
